<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:template match="Classifier | Method | Field" mode="DefinitionString">
    <xsl:choose>
      <xsl:when test="$prj_lang='csharp'">
        <xsl:apply-templates select="self::node()" mode="csharp"/>
      </xsl:when>
      <xsl:when test="$prj_lang='vbnet'">
        <xsl:apply-templates select="self::node()" mode="vbnet"/>
      </xsl:when>
      <xsl:when test="$prj_lang='design'">
        <xsl:apply-templates select="self::node()" mode="design"/>
      </xsl:when>
      <xsl:when test="$prj_lang='delphi'">
        <xsl:apply-templates select="self::node()" mode="delphi"/>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <!-- classifiers definition string templates -->
  <xsl:template match="Classifier" mode="csharp">
    
    <!-- visibility -->
    <xsl:call-template name="printVisibility"/>
    
    <!-- return type if delegate-->
    <xsl:if test="string(@type)='Delegate'">
        <xsl:variable name="typeName">
          <xsl:call-template name="typeRefHandler">
            <xsl:with-param name="parameter" select="ReturnType"></xsl:with-param>
          </xsl:call-template>
      </xsl:variable>
      <xsl:choose>
        <xsl:when test="string-length(string($typeName)) &gt; 0">
          <xsl:value-of select="$typeName"/>
          <xsl:text> </xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>void</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:text> </xsl:text>
    </xsl:if>
    
    <!-- definition keyword -->
    <xsl:call-template name="getDefinitionKeyword">
      <xsl:with-param name="class" select="self::node()"/>
    </xsl:call-template>
    <xsl:text> </xsl:text>
    
    <!-- name -->
    <xsl:value-of select="@name"/>
  </xsl:template>
  
  <xsl:template match="Classifier" mode="vbnet">
    
    <!-- visibility -->
    <xsl:call-template name="printVisibility"/>
    
    <!-- return type if delegate -->
    <xsl:if test="string(@type)='Delegate'">
      <xsl:variable name="typeName">
        <xsl:call-template name="typeRefHandler">
          <xsl:with-param name="parameter" select="ReturnType"></xsl:with-param>
        </xsl:call-template>
      </xsl:variable>
      <xsl:choose>
        <xsl:when test="string-length(string($typeName)) &gt; 0">
          <xsl:value-of select="$typeName"/>
          <xsl:text> </xsl:text>
        </xsl:when>
        <xsl:when test="current()/@isSubroutine">
          <xsl:text>Sub</xsl:text>
        </xsl:when>
        <xsl:otherwise>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:text> </xsl:text>
    </xsl:if>
    
    <!-- definition keyword -->
    <xsl:call-template name="getDefinitionKeyword">
      <xsl:with-param name="class" select="self::node()"/>
    </xsl:call-template>
    <xsl:text> </xsl:text>
    
    <!-- name -->
    <xsl:value-of select="@name"/>
  </xsl:template>
  
  <xsl:template match="Classifier" mode="delphi">

    <!-- keyword 'type' -->
    <xsl:call-template name="getLocalizedResource">
      <xsl:with-param name="code" select="'type'"/>
    </xsl:call-template>
    <xsl:text> </xsl:text>
    
    <!-- name -->
    <xsl:value-of select="@name"/>
    <xsl:text> = </xsl:text>

    <xsl:choose>
      <!-- parameters and return type if delegate -->
      <xsl:when test="string(@type)='Delegate'">
        <xsl:variable name="typeName">
          <xsl:call-template name="typeRefHandler">
            <xsl:with-param name="parameter" select="ReturnType"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:choose>
          <xsl:when test="string-length(string($typeName)) &gt; 0">
            <xsl:call-template name="getLocalizedResource">
              <xsl:with-param name="code" select="'function'"/>
            </xsl:call-template>
            <xsl:text>(</xsl:text>
            <xsl:for-each select="Parameter">
              <xsl:variable name="typeref">
                <xsl:call-template name="typeRefHandler">
                  <xsl:with-param name="parameter" select="current()"></xsl:with-param>
                </xsl:call-template>
              </xsl:variable>
              <xsl:value-of select="@elementName"></xsl:value-of>
              <xsl:text>: </xsl:text>
              <xsl:value-of select="$typeref"></xsl:value-of>
              <xsl:if test="not(position()=last())">
                <xsl:text>; </xsl:text>
              </xsl:if>
            </xsl:for-each>
            <xsl:text>)</xsl:text>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="getLocalizedResource">
              <xsl:with-param name="code" select="'procedure'"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
        <xsl:text> </xsl:text>
        <xsl:if test="string-length(string($typeName)) &gt; 0">
          <xsl:text>: </xsl:text>
          <xsl:value-of select="$typeName"/>
          <xsl:text> </xsl:text>
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <!-- definition keyword -->
        <xsl:call-template name="getDefinitionKeyword">
          <xsl:with-param name="class" select="self::node()"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  
  <xsl:template match="Classifier" mode="design">

    <xsl:call-template name="printVisibility"/>
    <xsl:call-template name="getDefinitionKeyword">
      <xsl:with-param name="class" select="self::node()"/>
    </xsl:call-template>
    <xsl:text> </xsl:text>
    <xsl:value-of select="@name"/>
  </xsl:template>
  
  <!-- Operation definition string templates -->
  <xsl:template match="Method" mode="csharp">
          
    <xsl:call-template name="printVisibility"/>
    <xsl:variable name="extern" select="Property[@name='Extern']" />
    <xsl:if test="$extern='True'">
      <xsl:text>extern </xsl:text>
    </xsl:if>

    <xsl:variable name="typeName">
      <xsl:call-template name="typeRefHandler">
        <xsl:with-param name="parameter" select="ReturnType"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="string-length(string($typeName)) &gt; 0">
        <xsl:value-of select="$typeName" />
      </xsl:when>
      <xsl:otherwise>
          <xsl:text>void</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text> </xsl:text>

    <xsl:variable name="m_name" select="@name"></xsl:variable>
    <xsl:variable name="indexer" select="@isIndexer" />
    <xsl:variable name="params" select="Parameter"></xsl:variable>
    <xsl:variable name="full_name">
      <xsl:value-of select="$m_name"></xsl:value-of>
      <xsl:choose>
        <xsl:when test="$indexer='true'">
          <xsl:text>[</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>(</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:for-each select="$params">
        <xsl:variable name="typeref">
          <xsl:call-template name="typeRefHandler">
            <xsl:with-param name="parameter" select="current()"></xsl:with-param>
          </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="$typeref"></xsl:value-of>
        <xsl:text> </xsl:text>
        <xsl:value-of select="@elementName"></xsl:value-of>
        <xsl:if test="not(position()=last())">
          <xsl:text>, </xsl:text>
        </xsl:if>
      </xsl:for-each>
      <xsl:choose>
        <xsl:when test="$indexer='true'">
          <xsl:text>]</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>)</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:value-of select="string($full_name)"></xsl:value-of>
  </xsl:template>
  
  <xsl:template match="Method" mode="vbnet">

    <xsl:call-template name="printVisibility"/>
    <xsl:variable name="extern" select="Property[@name='Extern']" />
    <xsl:if test="$extern='True'">
      <xsl:text>extern </xsl:text>
    </xsl:if>

    <xsl:variable name="typeName">
      <xsl:call-template name="typeRefHandler">
        <xsl:with-param name="parameter" select="ReturnType"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="string-length(string($typeName)) &gt; 0">
        <xsl:value-of select="$typeName" />
      </xsl:when>
      <xsl:when test="current()/@isSubroutine">
        <xsl:text>Sub</xsl:text>
      </xsl:when>
      <xsl:otherwise>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:text> </xsl:text>

    <xsl:variable name="m_name" select="@name"></xsl:variable>
    <xsl:variable name="indexer" select="@isIndexer" />
    <xsl:variable name="params" select="Parameter"></xsl:variable>
    <xsl:variable name="full_name">
      <xsl:value-of select="$m_name"></xsl:value-of>
      <xsl:choose>
        <xsl:when test="$indexer='true'">
          <xsl:text>[</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>(</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:for-each select="$params">
        <xsl:variable name="typeref">
          <xsl:call-template name="typeRefHandler">
            <xsl:with-param name="parameter" select="current()"></xsl:with-param>
          </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="$typeref"></xsl:value-of>
        <xsl:text> As </xsl:text>
        <xsl:value-of select="@elementName"></xsl:value-of>
        <xsl:if test="not(position()=last())">
          <xsl:text>, </xsl:text>
        </xsl:if>
      </xsl:for-each>
      <xsl:choose>
        <xsl:when test="$indexer='true'">
          <xsl:text>]</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>)</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:value-of select="string($full_name)"></xsl:value-of>
  </xsl:template>
  
  <xsl:template match="Method" mode="delphi">

    <xsl:call-template name="printVisibility"/>
    <xsl:variable name="extern" select="Property[@name='Extern']" />
    <xsl:if test="$extern='True'">
      <xsl:text>extern </xsl:text>
    </xsl:if>

    <xsl:variable name="indexer" select="@isIndexer"/>
    <xsl:variable name="params" select="Parameter"/>
    <xsl:variable name="full_name">
      <xsl:variable name="typeName">
        <xsl:call-template name="typeRefHandler">
          <xsl:with-param name="parameter" select="ReturnType"/>
        </xsl:call-template>
      </xsl:variable>
      <xsl:choose>
        <xsl:when test="string-length(string($typeName)) &gt; 0">
          <xsl:call-template name="getLocalizedResource">
            <xsl:with-param name="code" select="'function'"/>
          </xsl:call-template>
        </xsl:when>
        <xsl:otherwise>
          <xsl:choose>
            <xsl:when test="@isConstructor='true'">
              <xsl:call-template name="getLocalizedResource">
                <xsl:with-param name="code" select="'constructor'"/>
              </xsl:call-template>
            </xsl:when>
            <xsl:when test="@name=concat('~',parent::node()/@name)">
              <xsl:call-template name="getLocalizedResource">
                <xsl:with-param name="code" select="'destructor'"/>
              </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
              <xsl:call-template name="getLocalizedResource">
                <xsl:with-param name="code" select="'procedure'"/>
              </xsl:call-template>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:text> </xsl:text>

      <xsl:value-of select="@name"/>
      <xsl:choose>
        <xsl:when test="$indexer='true'">
          <xsl:text>[</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>(</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:for-each select="$params">
        <xsl:variable name="typeref">
          <xsl:call-template name="typeRefHandler">
            <xsl:with-param name="parameter" select="current()"></xsl:with-param>
          </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="@elementName"></xsl:value-of>
        <xsl:text>: </xsl:text>
        <xsl:value-of select="$typeref"></xsl:value-of>
        <xsl:if test="not(position()=last())">
          <xsl:text>; </xsl:text>
        </xsl:if>
      </xsl:for-each>
      <xsl:choose>
        <xsl:when test="$indexer='true'">
          <xsl:text>]</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:text>)</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:if test="string-length(string($typeName)) &gt; 0">
        <xsl:text>: </xsl:text>
        <xsl:value-of select="$typeName"/>
      </xsl:if>
    </xsl:variable>
    <xsl:value-of select="string($full_name)"></xsl:value-of>
  </xsl:template>
  
  <xsl:template match="Method" mode="design">
    <!-- visibility -->
    <xsl:call-template name="printVisibility"/>
    <!-- name -->
    <xsl:value-of select="@name"/>
    <xsl:text> </xsl:text>
    <!-- parameters -->
    <xsl:text>(</xsl:text>
    <xsl:variable name="params" select="Parameter"/>
    <xsl:for-each select="$params">
      <xsl:call-template name="ParameterUMLNotation">
        <xsl:with-param name="elem" select="current()"/>
      </xsl:call-template>
      <xsl:if test="not(position()=last())">
        <xsl:text>, </xsl:text>
      </xsl:if>
    </xsl:for-each>
    <xsl:text>)</xsl:text>
    <!-- return type -->
    <xsl:if test="ReturnType">
      <xsl:if test="string-length(ReturnType/@type) &gt; 0">
        <xsl:text>: </xsl:text>
        <xsl:variable name="typeref">
          <xsl:call-template name="typeRefHandler">
            <xsl:with-param name="parameter" select="ReturnType"></xsl:with-param>
          </xsl:call-template>
        </xsl:variable>
        <xsl:value-of select="$typeref"></xsl:value-of>
        <xsl:if test="@Multiplicity">
          <xsl:text>[</xsl:text>
          <xsl:value-of select="@Multiplicity"></xsl:value-of>
          <xsl:if test="@isOrdered='true'">
            <xsl:text> ordered </xsl:text>
          </xsl:if>
          <xsl:text>]</xsl:text>
        </xsl:if>
      </xsl:if>
    </xsl:if>
  </xsl:template>
  
  <!-- Attribute definition string templates -->
  <xsl:template match="Field" mode="csharp">
    <xsl:variable name="new" select="Property[@name='New']" />
    <xsl:if test="$new='True'">
      <xsl:text>new </xsl:text>
    </xsl:if>

    <xsl:call-template name="printVisibility"/>

    <xsl:variable name="const" select="Property[@name='Const']" />
    <xsl:if test="$const='True'">
      <xsl:text>const </xsl:text>
    </xsl:if>
    <xsl:variable name="readonly" select="Property[@name='Readonly']" />
    <xsl:if test="$readonly='True'">
      <xsl:text>readonly </xsl:text>
    </xsl:if>
    <xsl:variable name="static" select="Property[@name='Static']" />
    <xsl:if test="$static='True'">
      <xsl:text>static </xsl:text>
    </xsl:if>
    <xsl:variable name="volatile" select="Property[@name='Volatile']" />
    <xsl:if test="$volatile='True'">
      <xsl:text>volatile </xsl:text>
    </xsl:if>
    <xsl:variable name="extern" select="Property[@name='Extern']" />
    <xsl:if test="$extern='True'">
      <xsl:text>extern </xsl:text>
    </xsl:if>
    <xsl:variable name="event" select="@isEvent" />
    <xsl:if test="$event='true'">
      <xsl:text>event </xsl:text>
    </xsl:if>
    <xsl:call-template name="typeRefHandler">
      <xsl:with-param name="parameter" select="self::node()"/>
    </xsl:call-template>
    <xsl:text> </xsl:text>
    <xsl:value-of select="@elementName"/>
    <xsl:variable name="initial" select="@DefaultValue" />
    <xsl:if test="string-length($initial) &gt; 0">
      <xsl:text> = </xsl:text>
      <xsl:value-of select="$initial"/>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="Field" mode="vbnet">
    <xsl:variable name="new" select="Property[@name='New']" />
    <xsl:if test="$new='True'">
      <xsl:text>new </xsl:text>
    </xsl:if>

    <xsl:call-template name="printVisibility"/>

    <xsl:variable name="const" select="Property[@name='Const']" />
    <xsl:if test="$const='True'">
      <xsl:text>const </xsl:text>
    </xsl:if>
    <xsl:variable name="readonly" select="Property[@name='Readonly']" />
    <xsl:if test="$readonly='True'">
      <xsl:text>readonly </xsl:text>
    </xsl:if>
    <xsl:variable name="static" select="Property[@name='Static']" />
    <xsl:if test="$static='True'">
      <xsl:text>static </xsl:text>
    </xsl:if>
    <xsl:variable name="volatile" select="Property[@name='Volatile']" />
    <xsl:if test="$volatile='True'">
      <xsl:text>volatile </xsl:text>
    </xsl:if>
    <xsl:variable name="extern" select="Property[@name='Extern']" />
    <xsl:if test="$extern='True'">
      <xsl:text>extern </xsl:text>
    </xsl:if>
    <xsl:variable name="event" select="@isEvent" />
    <xsl:if test="$event='true'">
      <xsl:text>event </xsl:text>
    </xsl:if>
    <xsl:call-template name="typeRefHandler">
      <xsl:with-param name="parameter" select="self::node()"/>
    </xsl:call-template>
    <xsl:text> </xsl:text>
    <xsl:value-of select="@elementName"/>
    <xsl:variable name="initial" select="@DefaultValue" />
    <xsl:if test="string-length($initial) &gt; 0">
      <xsl:text> = </xsl:text>
      <xsl:value-of select="$initial"/>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="Field" mode="delphi">
    <xsl:variable name="new" select="Property[@name='New']" />
    <xsl:if test="$new='True'">
      <xsl:text>new </xsl:text>
    </xsl:if>

    <xsl:call-template name="printVisibility"/>

    <xsl:variable name="const" select="Property[@name='Const']" />
    <xsl:if test="$const='True'">
      <xsl:text>const </xsl:text>
    </xsl:if>
    <xsl:variable name="readonly" select="Property[@name='Readonly']" />
    <xsl:if test="$readonly='True'">
      <xsl:text>readonly </xsl:text>
    </xsl:if>
    <xsl:variable name="static" select="Property[@name='Static']" />
    <xsl:if test="$static='True'">
      <xsl:text>static </xsl:text>
    </xsl:if>
    <xsl:variable name="volatile" select="Property[@name='Volatile']" />
    <xsl:if test="$volatile='True'">
      <xsl:text>volatile </xsl:text>
    </xsl:if>
    <xsl:variable name="extern" select="Property[@name='Extern']" />
    <xsl:if test="$extern='True'">
      <xsl:text>extern </xsl:text>
    </xsl:if>
    <xsl:variable name="event" select="@isEvent" />
    <xsl:if test="$event='true'">
      <xsl:text>event </xsl:text>
    </xsl:if>
    <xsl:value-of select="@elementName"/>
    <xsl:text>: </xsl:text>
    <xsl:call-template name="typeRefHandler">
      <xsl:with-param name="parameter" select="self::node()"/>
    </xsl:call-template>
    <xsl:variable name="initial" select="@DefaultValue" />
    <xsl:if test="string-length($initial) &gt; 0">
      <xsl:text> = </xsl:text>
      <xsl:value-of select="$initial"/>
    </xsl:if>
  </xsl:template>
  
  <xsl:template match="Field" mode="design">
        <!-- visibility -->
        <xsl:call-template name="printVisibility"/>

        <!-- name -->
        <xsl:value-of select="@elementName"/>
        <xsl:text> </xsl:text>

        <!-- type -->
        <xsl:variable name="typeName">
          <xsl:call-template name="typeRefHandler">
            <xsl:with-param name="parameter" select="self::node()"/>
          </xsl:call-template>
        </xsl:variable>
        <xsl:if test="string-length($typeName) &gt; 0">
          <xsl:text>: </xsl:text>
          <xsl:value-of select="$typeName"/>
        </xsl:if>

        <!-- multiplicity -->
        <xsl:variable name="multi">
          <xsl:value-of select="@Multiplicity"/>
        </xsl:variable>
        <xsl:if test="string-length($multi) &gt; 0">
          <xsl:text>[ </xsl:text>
          <xsl:value-of select="$multi"/>
          <xsl:if test="@isOrdered='true'">
            <xsl:text> ordered </xsl:text>
          </xsl:if>
          <xsl:text> ] </xsl:text>
        </xsl:if>

        <!-- default value -->
        <xsl:variable name="def" select="@DefaultValue"/>
        <xsl:if test="string-length($def) &gt; 0">
          <xsl:text>= </xsl:text>
          <xsl:value-of select="$def"/>
        </xsl:if>
    </xsl:template>

  <xsl:template name="printVisibility">
    <xsl:param name="lang1" select="$prj_lang"/>
    <xsl:param name="vis" select="@visibility"/>

    <xsl:if test="string-length($vis) &gt; 0">
      <xsl:choose>
        <xsl:when test="$lang1='design'">
          <xsl:choose>
            <xsl:when test="$vis='public'">
              <xsl:text>+ </xsl:text>
            </xsl:when>
            <xsl:when test="$vis='protected'">
              <xsl:text># </xsl:text>
            </xsl:when>
            <xsl:when test="$vis='private'">
              <xsl:text>- </xsl:text>
            </xsl:when>
            <xsl:when test="$vis='package'">
              <xsl:text>~ </xsl:text>
            </xsl:when>
            <xsl:otherwise>
              <!-- unknown visibility notation-->
            </xsl:otherwise>
          </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
          <xsl:if test="not($vis='package')">
            <xsl:value-of select="$vis"/>
          </xsl:if>
          <xsl:text>&amp;nbsp;</xsl:text>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </xsl:template>

  <xsl:template name="getDefinitionKeyword">
    <xsl:param name="class"/>
    <xsl:choose>
      <xsl:when test="string($class/@type)='Interface'">
        <xsl:call-template name="getLocalizedResource">
          <xsl:with-param name="code" select="'tinterface'"></xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="string($class/@type)='Struct'">
        <xsl:call-template name="getLocalizedResource">
          <xsl:with-param name="code" select="'tstruct'"></xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="string($class/@type)='Enum'">
        <xsl:call-template name="getLocalizedResource">
          <xsl:with-param name="code" select="'tenum'"></xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="string($class/@type)='Delegate'">
        <xsl:call-template name="getLocalizedResource">
          <xsl:with-param name="code" select="'tdelegate'"></xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test="string($class/@type)='Module'">
        <xsl:call-template name="getLocalizedResource">
          <xsl:with-param name="code" select="'tmodule'"></xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="getLocalizedResource">
          <xsl:with-param name="code" select="'tclass'"></xsl:with-param>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>